/// <reference path="./internal_*.d.ts" />
declare namespace com.google.common.base {
    interface Function <F, T> extends Internal.Function<F, T> {
        abstract apply(arg0: F): T;
        compose<V>(arg0: Internal.Function_<V, F>): Internal.Function<V, T>;
        abstract equals(arg0: any): boolean;
        identity<T>(): Internal.Function<T, T>;
        andThen<V>(arg0: Internal.Function_<T, V>): Internal.Function<F, V>;
    }
    type Function_<F, T> = Function<F, T>;
}
declare namespace appeng.block.storage {
    class ChestBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly LIGHTS_ON: Internal.BooleanProperty;
    }
    type ChestBlock_ = ChestBlock;
}
declare namespace Internal {
    interface PalettedContainer$CountConsumer <T> {
        abstract accept(arg0: T, arg1: number): void;
        (arg0: T, arg1: number): void;
    }
    type PalettedContainer$CountConsumer_<T> = PalettedContainer$CountConsumer<T>;
    class VirtualPigment extends Internal.Item implements Internal.PigmentItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        provideColor(stack: Internal.ItemStack_, owner: Internal.UUID_): Internal.ColorProvider;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type VirtualPigment_ = VirtualPigment;
    class TallFlowerBlockBOP extends Internal.TallFlowerBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type TallFlowerBlockBOP_ = TallFlowerBlockBOP;
    class Ocelot extends Internal.Animal {
        constructor($$0: Internal.EntityType_<Internal.Ocelot>, $$1: Internal.Level_)
        static checkOcelotSpawnRules($$0: Internal.EntityType_<Internal.Ocelot>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        method_5958(): void;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly CROUCH_SPEED_MOD: 0.6;
        static readonly SPRINT_SPEED_MOD: 1.33;
        static readonly WALK_SPEED_MOD: 0.8;
    }
    type Ocelot_ = Ocelot;
    class ContextMenuItem implements Internal.Comparable<Internal.ContextMenuItem> {
        constructor(title: net.minecraft.network.chat.Component_, icon: Internal.Icon_, callback: Internal.Consumer_<dev.ftb.mods.ftblibrary.ui.Button>)
        compareTo(o: Internal.ContextMenuItem_): number;
        setEnabled(enabled: boolean): this;
        isClickable(): boolean;
        getYesNoText(): net.minecraft.network.chat.Component;
        setCloseMenu(v: boolean): this;
        static subMenu(title: net.minecraft.network.chat.Component_, icon: Internal.Icon_, subItems: Internal.List_<Internal.ContextMenuItem>): Internal.ContextMenuItem;
        compareTo(arg0: any): number;
        isEnabled(): boolean;
        static separator(): Internal.ContextMenuItem;
        drawIcon(graphics: Internal.GuiGraphics_, theme: Internal.Theme_, x: number, y: number, w: number, h: number): void;
        getIcon(): Internal.Icon;
        createWidget(panel: Internal.ContextMenu_): dev.ftb.mods.ftblibrary.ui.Widget;
        getTitle(): net.minecraft.network.chat.Component;
        onClicked(button: dev.ftb.mods.ftblibrary.ui.Button_, panel: Internal.Panel_, mouseButton: Internal.MouseButton_): void;
        addMouseOverText(list: Internal.TooltipList_): void;
        static title(title: net.minecraft.network.chat.Component_): Internal.ContextMenuItem;
        setYesNoText(s: net.minecraft.network.chat.Component_): this;
        set enabled(enabled: boolean)
        get clickable(): boolean
        get yesNoText(): net.minecraft.network.chat.Component
        set closeMenu(v: boolean)
        get enabled(): boolean
        get icon(): Internal.Icon
        get title(): net.minecraft.network.chat.Component
        set yesNoText(s: net.minecraft.network.chat.Component_)
        static readonly SEPARATOR: Internal.ContextMenuItem;
    }
    type ContextMenuItem_ = ContextMenuItem;
    interface IGenerallySearchableNavigation {
        abstract railways$findNearestApproachableSwitch(arg0: boolean): net.createmod.catnip.data.Pair<Internal.TrackSwitch, net.createmod.catnip.data.Pair<boolean, Internal.Optional<Internal.TrackSwitchBlock$SwitchState>>>;
        abstract railways$searchGeneral(arg0: number, arg1: number, arg2: boolean, arg3: Internal.IGenerallySearchableNavigation$PointTest_): void;
        abstract railways$searchGeneral(arg0: number, arg1: boolean, arg2: Internal.IGenerallySearchableNavigation$PointTest_): void;
    }
    type IGenerallySearchableNavigation_ = IGenerallySearchableNavigation;
    class KubeJSInventoryListener implements net.minecraft.world.inventory.ContainerListener {
        constructor(p: Internal.Player_)
        dataChanged(container: Internal.AbstractContainerMenu_, id: number, value: number): void;
        slotChanged(container: Internal.AbstractContainerMenu_, index: number, stack: Internal.ItemStack_): void;
        readonly player: Internal.Player;
    }
    type KubeJSInventoryListener_ = KubeJSInventoryListener;
    class ProfileKeyPair extends Internal.Record {
        constructor($$0: Internal.PrivateKey_, $$1: Internal.ProfilePublicKey_, $$2: Internal.Instant_)
        privateKey(): Internal.PrivateKey;
        dueRefresh(): boolean;
        refreshedAfter(): Internal.Instant;
        publicKey(): Internal.ProfilePublicKey;
        static readonly CODEC: Internal.Codec<Internal.ProfileKeyPair>;
    }
    type ProfileKeyPair_ = ProfileKeyPair;
    abstract class Minecraft$ChatStatus extends Internal.Enum<Internal.Minecraft$ChatStatus> {
        static valueOf($$0: string): Internal.Minecraft$ChatStatus;
        getMessage(): net.minecraft.network.chat.Component;
        static values(): Internal.Minecraft$ChatStatus[];
        abstract isChatAllowed(arg0: boolean): boolean;
        get message(): net.minecraft.network.chat.Component
        static readonly DISABLED_BY_OPTIONS: Internal.Minecraft$ChatStatus;
        static readonly DISABLED_BY_LAUNCHER: Internal.Minecraft$ChatStatus;
        static readonly ENABLED: Internal.Minecraft$ChatStatus;
        static readonly DISABLED_BY_PROFILE: Internal.Minecraft$ChatStatus;
    }
    type Minecraft$ChatStatus_ = Minecraft$ChatStatus | "enabled" | "disabled_by_profile" | "disabled_by_launcher" | "disabled_by_options";
    class MetricCategory extends Internal.Enum<Internal.MetricCategory> {
        static valueOf($$0: string): Internal.MetricCategory;
        static values(): Internal.MetricCategory[];
        getDescription(): string;
        get description(): string
        static readonly MAIL_BOXES: Internal.MetricCategory;
        static readonly CHUNK_RENDERING_DISPATCHING: Internal.MetricCategory;
        static readonly GPU: Internal.MetricCategory;
        static readonly JVM: Internal.MetricCategory;
        static readonly PATH_FINDING: Internal.MetricCategory;
        static readonly EVENT_LOOPS: Internal.MetricCategory;
        static readonly CHUNK_RENDERING: Internal.MetricCategory;
        static readonly TICK_LOOP: Internal.MetricCategory;
        static readonly CPU: Internal.MetricCategory;
    }
    type MetricCategory_ = "path_finding" | "cpu" | "jvm" | "chunk_rendering" | "mail_boxes" | "tick_loop" | "event_loops" | "gpu" | "chunk_rendering_dispatching" | MetricCategory;
    class ImmutableCollections$MapN <K, V> extends Internal.ImmutableCollections$AbstractImmutableMap<K, V> {
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        static of<K, V>(): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        get(arg0: any): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type ImmutableCollections$MapN_<K, V> = ImmutableCollections$MapN<K, V>;
    class CubeDeformation {
        constructor($$0: number)
        constructor($$0: number, $$1: number, $$2: number)
        extend($$0: number, $$1: number, $$2: number): this;
        extend($$0: number): this;
        static readonly NONE: Internal.CubeDeformation;
    }
    type CubeDeformation_ = CubeDeformation;
    class TrainStatusDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type TrainStatusDisplaySource_ = TrainStatusDisplaySource;
    class EntityLootEventJS extends Internal.LootEventJS {
        constructor(c: Internal.Map_<ResourceLocation, Internal.JsonElement>)
        addEntity(type: Internal.EntityType_<any>, b: Internal.Consumer_<Internal.LootBuilder>): void;
        modifyEntity(type: Internal.EntityType_<any>, b: Internal.Consumer_<Internal.LootBuilder>): void;
    }
    type EntityLootEventJS_ = EntityLootEventJS;
    class KineticStressDisplaySource extends Internal.PercentOrProgressBarDisplaySource {
        constructor()
    }
    type KineticStressDisplaySource_ = KineticStressDisplaySource;
    class LitBlazeBurnerBlock$FlameType extends Internal.Enum<Internal.LitBlazeBurnerBlock$FlameType> implements Internal.StringRepresentable {
        static values(): Internal.LitBlazeBurnerBlock$FlameType[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.LitBlazeBurnerBlock$FlameType;
        get serializedName(): string
        static readonly REGULAR: Internal.LitBlazeBurnerBlock$FlameType;
        static readonly SOUL: Internal.LitBlazeBurnerBlock$FlameType;
    }
    type LitBlazeBurnerBlock$FlameType_ = "soul" | "regular" | LitBlazeBurnerBlock$FlameType;
    abstract class ParticleType <T extends Internal.ParticleOptions> {
        getDeserializer(): Internal.ParticleOptions$Deserializer<T>;
        abstract codec(): Internal.Codec<T>;
        getOverrideLimiter(): boolean;
        get deserializer(): Internal.ParticleOptions$Deserializer<T>
        get overrideLimiter(): boolean
    }
    type ParticleType_<T extends Internal.ParticleOptions> = Special.ParticleType | ParticleType<T>;
    class BlockApiCacheImpl <A, C> implements Internal.BlockApiCache<A, C> {
        constructor(lookup: Internal.BlockApiLookupImpl_<A, C>, world: Internal.ServerLevel_, pos: BlockPos_)
        getPos(): BlockPos;
        find(context: C): A;
        getBlockEntity(): Internal.BlockEntity;
        find(state: Internal.BlockState_, context: C): A;
        getLookup(): Internal.BlockApiLookup<any, any>;
        invalidate(): void;
        getWorld(): Internal.ServerLevel;
        static create<A, C>(lookup: Internal.BlockApiLookup_<A, C>, world: Internal.ServerLevel_, pos: BlockPos_): Internal.BlockApiCache<A, C>;
        get pos(): BlockPos
        get blockEntity(): Internal.BlockEntity
        get lookup(): Internal.BlockApiLookup<any, any>
        get world(): Internal.ServerLevel
    }
    type BlockApiCacheImpl_<A, C> = BlockApiCacheImpl<A, C>;
    class ChunkBufferBuilderPack implements Internal.ChunkBufferBuilderPackAccessor {
        constructor()
        discardAll(): void;
        clearAll(): void;
        getField_3951(): Internal.Map<any, any>;
        builder($$0: Internal.RenderType_): Internal.BufferBuilder;
        get field_3951(): Internal.Map<any, any>
    }
    type ChunkBufferBuilderPack_ = ChunkBufferBuilderPack;
    class VertexFormat$Mode extends Internal.Enum<Internal.VertexFormat$Mode> {
        static valueOf($$0: string): Internal.VertexFormat$Mode;
        indexCount($$0: number): number;
        static values(): Internal.VertexFormat$Mode[];
        static readonly DEBUG_LINE_STRIP: Internal.VertexFormat$Mode;
        static readonly TRIANGLE_STRIP: Internal.VertexFormat$Mode;
        static readonly DEBUG_LINES: Internal.VertexFormat$Mode;
        static readonly LINE_STRIP: Internal.VertexFormat$Mode;
        static readonly TRIANGLE_FAN: Internal.VertexFormat$Mode;
        readonly connectedPrimitives: boolean;
        static readonly LINES: Internal.VertexFormat$Mode;
        static readonly TRIANGLES: Internal.VertexFormat$Mode;
        static readonly QUADS: Internal.VertexFormat$Mode;
        readonly asGLMode: number;
        readonly primitiveLength: number;
        readonly primitiveStride: number;
    }
    type VertexFormat$Mode_ = "triangles" | "triangle_fan" | "debug_line_strip" | "line_strip" | "triangle_strip" | "debug_lines" | VertexFormat$Mode | "quads" | "lines";
    class ClientboundOpenScreenPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: Internal.MenuType_<any>, $$2: net.minecraft.network.chat.Component_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getType(): Internal.MenuType<any>;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getTitle(): net.minecraft.network.chat.Component;
        getContainerId(): number;
        isSkippable(): boolean;
        get type(): Internal.MenuType<any>
        get title(): net.minecraft.network.chat.Component
        get containerId(): number
        get skippable(): boolean
    }
    type ClientboundOpenScreenPacket_ = ClientboundOpenScreenPacket;
    interface HeightmapAccessor {
        abstract getBlockPredicate(): Internal.Predicate<Internal.BlockState>;
        abstract callSet(arg0: number, arg1: number, arg2: number): void;
        get blockPredicate(): Internal.Predicate<Internal.BlockState>
    }
    type HeightmapAccessor_ = HeightmapAccessor;
    class EvalSound extends Internal.Record {
        constructor(sound: Internal.SoundEvent_, priority: number)
        priority(): number;
        greaterOf(that: Internal.EvalSound_): this;
        sound(): Internal.SoundEvent;
    }
    type EvalSound_ = Special.EvalSound | EvalSound;
    class ItemExtendedAmethystStaff extends Internal.ItemBatteryStaff {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly CAPACITY_IN_DUST: 50;
        static readonly GRID_ZOOM: Internal.AttributeModifier;
    }
    type ItemExtendedAmethystStaff_ = ItemExtendedAmethystStaff;
    class ObjectiveCriteria$RenderType extends Internal.Enum<Internal.ObjectiveCriteria$RenderType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.ObjectiveCriteria$RenderType;
        getSerializedName(): string;
        static byId($$0: string): Internal.ObjectiveCriteria$RenderType;
        getId(): string;
        static values(): Internal.ObjectiveCriteria$RenderType[];
        get serializedName(): string
        get id(): string
        static readonly HEARTS: Internal.ObjectiveCriteria$RenderType;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.ObjectiveCriteria$RenderType>;
        static readonly INTEGER: Internal.ObjectiveCriteria$RenderType;
    }
    type ObjectiveCriteria$RenderType_ = ObjectiveCriteria$RenderType | "hearts" | "integer";
    interface Optic <Proof extends Internal.K1, S, T, A, B> {
        abstract "eval"<P extends Internal.K2>(arg0: Internal.App_<Proof, P>): Internal.Function<Internal.App2<P, A, B>, Internal.App2<P, S, T>>;
        upCast<Proof2 extends Internal.K1>(arg0: Internal.Set_<Internal.TypeToken<Internal.K1>>, arg1: Internal.TypeToken_<Proof2>): Internal.Optional<Internal.Optic<Proof2, S, T, A, B>>;
        (arg0: Internal.App<Proof, P>): Internal.Function_<Internal.App2<P, A, B>, Internal.App2<P, S, T>>;
    }
    type Optic_<Proof extends Internal.K1, S, T, A, B> = Optic<Proof, S, T, A, B>;
    abstract class ModelFile {
        getLocation(): ResourceLocation;
        getUncheckedLocation(): ResourceLocation;
        assertExistence(): void;
        get location(): ResourceLocation
        get uncheckedLocation(): ResourceLocation
    }
    type ModelFile_ = ModelFile;
    class RestrictedCompoundTag {
        constructor(tag: Internal.CompoundTag_, restrictedKeys: Internal.Set_<string>)
        getList(name: string, type: number): Internal.ListTag;
        getInt(name: string): number;
        getFloat(name: string): number;
        getCompound(name: string): Internal.CompoundTag;
        get(name: string): Internal.Tag;
        getBoolean(name: string): boolean;
        putString(name: string, value: string): void;
        putFloat(name: string, value: number): void;
        getString(name: string): string;
        put(name: string, nbt: Internal.Tag_): void;
        putBoolean(name: string, value: boolean): void;
        remove(name: string): void;
        putInt(name: string, value: number): void;
        contains(name: string, type: number): boolean;
    }
    type RestrictedCompoundTag_ = RestrictedCompoundTag;
    class SlimeGrassSeedItem extends Internal.TooltipItem {
        constructor(properties: Internal.Item$Properties_, foliage: Internal.SlimeType_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SlimeGrassSeedItem_ = SlimeGrassSeedItem;
    class PartialModel implements Internal.AccessorPartialModel {
        static railways$setPopulateOnInit(tooLate: boolean): void;
        railways$setBakedModel(arg0: Internal.BakedModel_): void;
        static setPopulateOnInit$railways_$md$fca01f$1(arg0: boolean): void;
        modelLocation(): ResourceLocation;
        static getPopulateOnInit$railways_$md$fca01f$2(): boolean;
        static railways$getPopulateOnInit(): boolean;
        get(): Internal.BakedModel;
        static of(modelLocation: ResourceLocation_): Internal.PartialModel;
        static railways$getALL(): Internal.ConcurrentMap<ResourceLocation, Internal.PartialModel>;
        static getALL$railways_$md$fca01f$0(): Internal.ConcurrentMap<any, any>;
        set populateOnInit$railways_$md$fca01f$1(arg0: boolean)
        get populateOnInit$railways_$md$fca01f$2(): boolean
        get ALL$railways_$md$fca01f$0(): Internal.ConcurrentMap<any, any>
    }
    type PartialModel_ = PartialModel;
    class PinkPetalsBlock extends Internal.BushBlock implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly MIN_FLOWERS: 1;
        static readonly MAX_FLOWERS: 4;
        static readonly FACING: Internal.DirectionProperty;
        static readonly AMOUNT: Internal.IntegerProperty;
    }
    type PinkPetalsBlock_ = PinkPetalsBlock;
    abstract class EmiStack$Entry <T> {
        constructor(value: any)
        abstract getType(): typeof any;
        getValue(): any;
        get type(): typeof any
        get value(): any
    }
    type EmiStack$Entry_<T> = EmiStack$Entry<T>;
    class SweetBerryBushBlock extends Internal.BushBlock implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 3;
    }
    type SweetBerryBushBlock_ = SweetBerryBushBlock;
    class RenderStateShard$LineStateShard extends Internal.RenderStateShard {
        constructor($$0: Internal.OptionalDouble_)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShard$LineStateShard_ = RenderStateShard$LineStateShard;
    abstract class FloatProvider implements Internal.SampledFloat {
        constructor()
        abstract sample(arg0: Internal.RandomSource_): number;
        abstract getMinValue(): number;
        abstract getMaxValue(): number;
        static codec($$0: number, $$1: number): Internal.Codec<Internal.FloatProvider>;
        abstract getType(): Internal.FloatProviderType<any>;
        get minValue(): number
        get maxValue(): number
        get type(): Internal.FloatProviderType<any>
        static readonly CODEC: Internal.Codec<Internal.FloatProvider>;
    }
    type FloatProvider_ = FloatProvider;
    interface ServerEntityManagerAccessor <T extends Internal.EntityAccess> {
        abstract getCache(): Internal.EntitySectionStorage<T>;
        get cache(): Internal.EntitySectionStorage<T>
        (): Internal.EntitySectionStorage_<T>;
    }
    type ServerEntityManagerAccessor_<T extends Internal.EntityAccess> = ServerEntityManagerAccessor<T>;
    class MerchantMenu extends Internal.AbstractContainerMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: Internal.Merchant_)
        constructor($$0: number, $$1: Internal.Inventory_)
        getTraderXp(): number;
        setMerchantLevel($$0: number): void;
        canRestock(): boolean;
        getOffers(): Internal.MerchantOffers;
        tryMoveItems($$0: number): void;
        setSelectionHint($$0: number): void;
        getTraderLevel(): number;
        setCanRestock($$0: boolean): void;
        showProgressBar(): boolean;
        setShowProgressBar($$0: boolean): void;
        setOffers($$0: Internal.MerchantOffers_): void;
        setXp($$0: number): void;
        getFutureTraderXp(): number;
        get traderXp(): number
        set merchantLevel($$0: number)
        get offers(): Internal.MerchantOffers
        set selectionHint($$0: number)
        get traderLevel(): number
        set canRestock($$0: boolean)
        set showProgressBar($$0: boolean)
        set offers($$0: Internal.MerchantOffers_)
        set xp($$0: number)
        get futureTraderXp(): number
    }
    type MerchantMenu_ = MerchantMenu;
    class LegSolver {
        constructor(...legs: Internal.LegSolver$Leg_[])
        update(entity: Internal.EntityDragonBase_, yaw: number, scale: number): void;
        update(entity: Internal.EntityDragonBase_, scale: number): void;
        readonly legs: Internal.LegSolver$Leg[];
    }
    type LegSolver_ = LegSolver;
    class ServerboundEntityTagQuery implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: number, $$1: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getEntityId(): number;
        getTransactionId(): number;
        isSkippable(): boolean;
        get entityId(): number
        get transactionId(): number
        get skippable(): boolean
    }
    type ServerboundEntityTagQuery_ = ServerboundEntityTagQuery;
    class ItemCypher extends Internal.ItemPackagedHex implements Internal.VariantItem {
        constructor(pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        getVariant(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        setVariant(stack: Internal.ItemStack_, variant: number): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getMediaFullness(stack: Internal.ItemStack_): number;
        emi(amount: number): Internal.EmiStack;
        clampVariant(variant: number): number;
        numVariants(): number;
        withdrawMedia(stack: Internal.ItemStack_, cost: number, simulate: boolean): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemCypher_ = ItemCypher;
    class RetexturedOrientableSmelteryBlock extends Internal.OrientableSmelteryBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, blockEntity: any_<any>)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type RetexturedOrientableSmelteryBlock_ = RetexturedOrientableSmelteryBlock;
    interface ArsenalWeaponItem {
    }
    type ArsenalWeaponItem_ = ArsenalWeaponItem;
    class RecipePipeBlock extends Internal.NetworkedPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type RecipePipeBlock_ = RecipePipeBlock;
    class MoltenBrassFluid$Flowing extends Internal.MoltenBrassFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenBrassFluid$Flowing_ = MoltenBrassFluid$Flowing;
    abstract class ImmutableMap <K, V> implements Internal.Map<K, V>, Internal.Serializable {
        /**
         * @deprecated
        */
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.ImmutableMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.ImmutableMap<K, V>;
        static toImmutableMap<T, K, V>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, V>, arg2: Internal.BinaryOperator_<V>): Internal.Collector<T, any, Internal.ImmutableMap<K, V>>;
        static of<K, V>(arg0: K, arg1: V): Internal.ImmutableMap<K, V>;
        static toImmutableMap<T, K, V>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, V>): Internal.Collector<T, any, Internal.ImmutableMap<K, V>>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.ImmutableMap<K, V>;
        containsValue(arg0: any): boolean;
        /**
         * @deprecated
        */
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.ImmutableMap<K, V>;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.ImmutableMap<K, V>;
        isEmpty(): boolean;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.ImmutableMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.ImmutableMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.ImmutableMap<K, V>;
        abstract get(arg0: any): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.ImmutableMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.ImmutableMap<K, V>;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        values(): Internal.Collection<any>;
        /**
         * @deprecated
        */
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        asMultimap(): Internal.ImmutableSetMultimap<K, V>;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: K, arg1: V): V;
        entrySet(): Internal.Set<any>;
        static builderWithExpectedSize<K, V>(arg0: number): Internal.ImmutableMap$Builder<K, V>;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.ImmutableMap<K, V>;
        /**
         * @deprecated
        */
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static copyOf<K, V>(arg0: Internal.Iterable_<Internal.Map$Entry<K, V>>): Internal.ImmutableMap<K, V>;
        /**
         * @deprecated
        */
        remove(arg0: any, arg1: any): boolean;
        /**
         * @deprecated
        */
        putAll(arg0: Internal.Map_<K, V>): void;
        static of<K, V>(): Internal.ImmutableMap<K, V>;
        abstract size(): number;
        /**
         * @deprecated
        */
        clear(): void;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: V, arg2: V): boolean;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        static builder<K, V>(): Internal.ImmutableMap$Builder<K, V>;
        keySet(): Internal.ImmutableSet<K>;
        get empty(): boolean
    }
    type ImmutableMap_<K, V> = ImmutableMap<K, V>;
    class MoltenBronzeFluid$Source extends Internal.MoltenBronzeFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenBronzeFluid$Source_ = MoltenBronzeFluid$Source;
    class InventoryChangeTrigger$TriggerInstance extends Internal.AbstractCriterionTriggerInstance {
        constructor($$0: any_, $$1: Internal.MinMaxBounds$Ints_, $$2: Internal.MinMaxBounds$Ints_, $$3: Internal.MinMaxBounds$Ints_, $$4: any_[])
        matches($$0: Internal.Inventory_, $$1: Internal.ItemStack_, $$2: number, $$3: number, $$4: number): boolean;
        static hasItems(...$$0: any_[]): Internal.InventoryChangeTrigger$TriggerInstance;
        static hasItems(...$$0: Internal.ItemLike_[]): Internal.InventoryChangeTrigger$TriggerInstance;
    }
    type InventoryChangeTrigger$TriggerInstance_ = InventoryChangeTrigger$TriggerInstance;
    class RenderType$OutlineProperty extends Internal.Enum<Internal.RenderType$OutlineProperty> {
        static values(): Internal.RenderType$OutlineProperty[];
        static valueOf($$0: string): Internal.RenderType$OutlineProperty;
        static readonly NONE: Internal.RenderType$OutlineProperty;
        static readonly AFFECTS_OUTLINE: Internal.RenderType$OutlineProperty;
        static readonly IS_OUTLINE: Internal.RenderType$OutlineProperty;
    }
    type RenderType$OutlineProperty_ = RenderType$OutlineProperty | "is_outline" | "affects_outline" | "none";
    interface App <F extends Internal.K1, A> {
    }
    type App_<F extends Internal.K1, A> = App<F, A>;
    class Boat$Status extends Internal.Enum<Internal.Boat$Status> {
        static valueOf($$0: string): Internal.Boat$Status;
        static values(): Internal.Boat$Status[];
        static readonly IN_AIR: Internal.Boat$Status;
        static readonly UNDER_FLOWING_WATER: Internal.Boat$Status;
        static readonly ON_LAND: Internal.Boat$Status;
        static readonly IN_WATER: Internal.Boat$Status;
        static readonly UNDER_WATER: Internal.Boat$Status;
    }
    type Boat$Status_ = Boat$Status | "in_water" | "in_air" | "under_water" | "under_flowing_water" | "on_land";
    class HatShapedRecipe$Type implements Internal.RecipeType<Internal.HatShapedRecipe> {
        static register<T extends Internal.Recipe<any>>($$0: string): Internal.RecipeType<T>;
        static readonly INSTANCE: Internal.HatShapedRecipe$Type;
    }
    type HatShapedRecipe$Type_ = HatShapedRecipe$Type;
    interface LoggedChatEvent {
        abstract type(): Internal.LoggedChatEvent$Type;
        (): Internal.LoggedChatEvent$Type_;
        readonly CODEC: Internal.Codec<Internal.LoggedChatEvent>;
    }
    type LoggedChatEvent_ = LoggedChatEvent;
    class AxisSmokeStackBlock extends Internal.SmokeStackBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, type: Internal.SmokeStackBlock$SmokeStackType_, shape: any_, createsStationarySmoke: boolean, variant: string)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SmokeStackBlockEntity>;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SmokeStackBlockEntity;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SmokeStackBlockEntity>): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SmokeStackBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    }
    type AxisSmokeStackBlock_ = AxisSmokeStackBlock;
    interface IRenderedBatteryUpgrade {
        abstract forceUpdateBatteryRenderInfo(): void;
        abstract setBatteryRenderInfoUpdateCallback(arg0: Internal.Consumer_<Internal.IRenderedBatteryUpgrade$BatteryRenderInfo>): void;
        set batteryRenderInfoUpdateCallback(arg0: Internal.Consumer_<Internal.IRenderedBatteryUpgrade$BatteryRenderInfo>)
    }
    type IRenderedBatteryUpgrade_ = IRenderedBatteryUpgrade;
    interface IShearable {
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
    }
    type IShearable_ = IShearable;
    class Bee extends Internal.Animal implements Internal.FlyingAnimal, Internal.NeutralMob {
        constructor($$0: Internal.EntityType_<Internal.Bee>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getBlacklistedHives(): Internal.List<BlockPos>;
        isTouchingUpsideDownFluid(): boolean;
        hasSavedFlowerPos(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        hasHive(): boolean;
        readPersistentAngerSaveData($$0: Internal.Level_, $$1: Internal.CompoundTag_): void;
        stopBeingAngry(): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        incrementNumCropsGrownSincePollination(): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        getGoalSelector(): Internal.GoalSelector;
        isFlying(): boolean;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        forgetCurrentTargetAndRefreshUniversalAnger(): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        addPersistentAngerSaveData($$0: Internal.CompoundTag_): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        getPersistentAngerTarget(): Internal.UUID;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        method_5776(): boolean;
        getHivePos(): BlockPos;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        isAngryAtAllPlayers($$0: Internal.Level_): boolean;
        foodEaten(is: Internal.ItemStack_): void;
        hasStung(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        resetTicksWithoutNectarSinceExitingHive(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        playerDied($$0: Internal.Player_): void;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getTravellingTicks(): number;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isAngry(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        startPersistentAngerTimer(): void;
        isMonster(): boolean;
        getSavedFlowerPos(): BlockPos;
        setStayOutOfHiveCountdown($$0: number): void;
        setRemainingPersistentAngerTime($$0: number): void;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        hasNectar(): boolean;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        setPersistentAngerTarget($$0: Internal.UUID_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        isAngryAt($$0: Internal.LivingEntity_): boolean;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getRemainingPersistentAngerTime(): number;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        setSavedFlowerPos($$0: BlockPos_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        dropOffNectar(): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getRollAmount($$0: number): number;
        getProfile(): Internal.GameProfile;
        updatePersistentAnger($$0: Internal.ServerLevel_, $$1: boolean): void;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get blacklistedHives(): Internal.List<BlockPos>
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get goalSelector(): Internal.GoalSelector
        get flying(): boolean
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get persistentAngerTarget(): Internal.UUID
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get hivePos(): BlockPos
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get travellingTicks(): number
        get peacefulCreature(): boolean
        get angry(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get savedFlowerPos(): BlockPos
        set stayOutOfHiveCountdown($$0: number)
        set remainingPersistentAngerTime($$0: number)
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        set persistentAngerTarget($$0: Internal.UUID_)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get remainingPersistentAngerTime(): number
        set savedFlowerPos($$0: BlockPos_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly TAG_TICKS_SINCE_POLLINATION: "TicksSincePollination";
        static readonly TAG_HAS_NECTAR: "HasNectar";
        static readonly TAG_CANNOT_ENTER_HIVE_TICKS: "CannotEnterHiveTicks";
        static readonly TICKS_PER_FLAP: 2;
        static readonly TAG_FLOWER_POS: "FlowerPos";
        static readonly FLAP_DEGREES_PER_TICK: 120.32113;
        static readonly TAG_HIVE_POS: "HivePos";
        static readonly TAG_HAS_STUNG: "HasStung";
        static readonly TAG_CROPS_GROWN_SINCE_POLLINATION: "CropsGrownSincePollination";
    }
    type Bee_ = Bee;
    class JobAttributes$DefaultSelectionType extends Internal.AttributeValue {
        static readonly SELECTION: Internal.JobAttributes$DefaultSelectionType;
        static readonly ALL: Internal.JobAttributes$DefaultSelectionType;
        static readonly RANGE: Internal.JobAttributes$DefaultSelectionType;
    }
    type JobAttributes$DefaultSelectionType_ = JobAttributes$DefaultSelectionType;
    class MoltenElectrumFluid$Source extends Internal.MoltenElectrumFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenElectrumFluid$Source_ = MoltenElectrumFluid$Source;
    class MultilevelModifierRecipe extends Internal.ModifierRecipe implements Internal.IMultiRecipe<Internal.IDisplayModifierRecipe> {
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        getRemainingItems(inv: Internal.ITinkerStationContainer_): Internal.NonNullList<Internal.ItemStack>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getRecipes(): Internal.List<Internal.IDisplayModifierRecipe>;
        getSlotType(): Internal.SlotType;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        isIncremental(): boolean;
        getMod(): string;
        static withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_): Internal.ItemStack;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        assemble(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        static withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_, persistentDataConsumer: Internal.Consumer_<Internal.ModDataNBT>): Internal.ItemStack;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getModifier(): Internal.Modifier;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get recipes(): Internal.List<Internal.IDisplayModifierRecipe>
        get slotType(): Internal.SlotType
        get incremental(): boolean
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get modifier(): Internal.Modifier
    }
    type MultilevelModifierRecipe_ = MultilevelModifierRecipe;
    class MonitorEdgeState extends Internal.Enum<Internal.MonitorEdgeState> implements Internal.StringRepresentable {
        static fromConnections(up: boolean, down: boolean, left: boolean, right: boolean): Internal.MonitorEdgeState;
        static valueOf(name: string): Internal.MonitorEdgeState;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.MonitorEdgeState[];
        get serializedName(): string
        static readonly LUD: Internal.MonitorEdgeState;
        static readonly LD: Internal.MonitorEdgeState;
        static readonly D: Internal.MonitorEdgeState;
        static readonly NONE: Internal.MonitorEdgeState;
        static readonly RD: Internal.MonitorEdgeState;
        static readonly LRU: Internal.MonitorEdgeState;
        static readonly L: Internal.MonitorEdgeState;
        static readonly UD: Internal.MonitorEdgeState;
        static readonly R: Internal.MonitorEdgeState;
        static readonly LU: Internal.MonitorEdgeState;
        static readonly LR: Internal.MonitorEdgeState;
        static readonly U: Internal.MonitorEdgeState;
        static readonly RUD: Internal.MonitorEdgeState;
        static readonly RU: Internal.MonitorEdgeState;
        static readonly LRD: Internal.MonitorEdgeState;
        static readonly LRUD: Internal.MonitorEdgeState;
    }
    type MonitorEdgeState_ = "d" | "ud" | "lru" | "lu" | "lrud" | "lr" | "ru" | MonitorEdgeState | "none" | "u" | "r" | "rud" | "lrd" | "l" | "lud" | "ld" | "rd";
    class ParsePosition {
        constructor(arg0: number)
        setErrorIndex(arg0: number): void;
        getErrorIndex(): number;
        getIndex(): number;
        setIndex(arg0: number): void;
        set errorIndex(arg0: number)
        get errorIndex(): number
        get index(): number
        set index(arg0: number)
    }
    type ParsePosition_ = ParsePosition;
    class SmithingUpgradeItem extends Internal.UpgradeItemBase<Internal.SmithingUpgradeWrapper> {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        getType(): Internal.UpgradeType<Internal.SmithingUpgradeWrapper>;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get type(): Internal.UpgradeType<Internal.SmithingUpgradeWrapper>
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SmithingUpgradeItem_ = SmithingUpgradeItem;
    class BlockFallingGeneric extends Internal.FallingBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        static builder(hardness: number, resistance: number, sound: SoundType_, color: Internal.MapColor_, instrument: Internal.NoteBlockInstrument_): Internal.BlockFallingGeneric;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        onLand($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BlockState_, $$4: Internal.FallingBlockEntity_): void;
        setRequiresTool(v: boolean): void;
        onBrokenAfterFall($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FallingBlockEntity_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFallDamageSource($$0: Internal.Entity_): DamageSource;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockFallingGeneric_ = BlockFallingGeneric;
    interface Deque <E> extends Internal.SequencedCollection<E>, Internal.Queue<E> {
        abstract addLast(arg0: E): void;
        abstract getLast(): E;
        abstract peekLast(): E;
        abstract add(arg0: E): boolean;
        abstract remove(): E;
        abstract element(): E;
        abstract removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        abstract isEmpty(): boolean;
        abstract poll(): E;
        reversed(): this;
        abstract offerFirst(arg0: E): boolean;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        abstract removeFirstOccurrence(arg0: any): boolean;
        abstract contains(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        abstract descendingIterator(): Internal.Iterator<E>;
        abstract peek(): E;
        abstract addFirst(arg0: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract offer(arg0: E): boolean;
        abstract pop(): E;
        abstract toArray(): any[];
        abstract getFirst(): E;
        abstract iterator(): Internal.Iterator<E>;
        abstract offerLast(arg0: E): boolean;
        abstract size(): number;
        abstract pollFirst(): E;
        abstract hashCode(): number;
        abstract peekFirst(): E;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract removeLastOccurrence(arg0: any): boolean;
        abstract push(arg0: E): void;
        abstract clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        abstract removeLast(): E;
        spliterator(): Internal.Spliterator<E>;
        abstract pollLast(): E;
        abstract equals(arg0: any): boolean;
        get last(): E
        get empty(): boolean
        get first(): E
    }
    type Deque_<E> = Deque<E>;
    class ThinLamp extends Internal.RotatableLamp {
        constructor(thickness: number)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type ThinLamp_ = ThinLamp;
    interface Arithmetic {
        abstract getOperator(arg0: Internal.HexPattern_): Internal.Operator;
        abstract opTypes(): Internal.Iterable<Internal.HexPattern>;
        abstract arithName(): string;
        readonly UNCONS: Internal.HexPattern;
        readonly DIV: Internal.HexPattern;
        readonly ARCTAN: Internal.HexPattern;
        readonly FLOOR: Internal.HexPattern;
        readonly INDEX: Internal.HexPattern;
        readonly ABS: Internal.HexPattern;
        readonly SLICE: Internal.HexPattern;
        readonly AND: Internal.HexPattern;
        readonly UNAPPEND: Internal.HexPattern;
        readonly UNIQUE: Internal.HexPattern;
        readonly CONS: Internal.HexPattern;
        readonly POW: Internal.HexPattern;
        readonly GREATER_EQ: Internal.HexPattern;
        readonly SIN: Internal.HexPattern;
        readonly APPEND: Internal.HexPattern;
        readonly ADD: Internal.HexPattern;
        readonly CEIL: Internal.HexPattern;
        readonly LESS_EQ: Internal.HexPattern;
        readonly ARCSIN: Internal.HexPattern;
        readonly INDEX_OF: Internal.HexPattern;
        readonly ARCCOS: Internal.HexPattern;
        readonly REPLACE: Internal.HexPattern;
        readonly MOD: Internal.HexPattern;
        readonly OR: Internal.HexPattern;
        readonly SUB: Internal.HexPattern;
        readonly UNPACK: Internal.HexPattern;
        readonly MUL: Internal.HexPattern;
        readonly LOG: Internal.HexPattern;
        readonly REV: Internal.HexPattern;
        readonly TAN: Internal.HexPattern;
        readonly ARCTAN2: Internal.HexPattern;
        readonly PACK: Internal.HexPattern;
        readonly REMOVE: Internal.HexPattern;
        readonly XOR: Internal.HexPattern;
        readonly GREATER: Internal.HexPattern;
        readonly COS: Internal.HexPattern;
        readonly LESS: Internal.HexPattern;
        readonly NOT: Internal.HexPattern;
    }
    type Arithmetic_ = Arithmetic | Special.Arithmetic;
    class BlackstoneReplaceProcessor extends Internal.StructureProcessor {
        static readonly INSTANCE: Internal.BlackstoneReplaceProcessor;
        static readonly CODEC: Internal.Codec<Internal.BlackstoneReplaceProcessor>;
    }
    type BlackstoneReplaceProcessor_ = BlackstoneReplaceProcessor;
    class Ops extends Internal.ValueObject {
        constructor()
        static parse($$0: string): Internal.Ops;
        ops: Internal.Set<string>;
    }
    type Ops_ = Ops;
    class LootContextParam <T> {
        constructor($$0: ResourceLocation_)
        getName(): ResourceLocation;
        get name(): ResourceLocation
    }
    type LootContextParam_<T> = LootContextParam<T>;
    abstract class PalettedContainer$Strategy {
        constructor($$0: number)
        size(): number;
        abstract getConfiguration<A>(arg0: Internal.IdMap_<A>, arg1: number): Internal.PalettedContainer$Configuration<A>;
        getIndex($$0: number, $$1: number, $$2: number): number;
        calculateBitsForSerialization<A>($$0: Internal.IdMap_<A>, $$1: number): number;
        static readonly HASHMAP_PALETTE_FACTORY: Internal.Palette$Factory;
        static readonly LINEAR_PALETTE_FACTORY: Internal.Palette$Factory;
        static readonly SINGLE_VALUE_PALETTE_FACTORY: Internal.Palette$Factory;
        static SECTION_BIOMES: Internal.PalettedContainer$Strategy;
        static SECTION_STATES: Internal.PalettedContainer$Strategy;
    }
    type PalettedContainer$Strategy_ = PalettedContainer$Strategy;
    class ItemModelType extends Internal.Enum<Internal.ItemModelType> {
        static values(): Internal.ItemModelType[];
        static valueOf(name: string): Internal.ItemModelType;
        static readonly HANDHELD: Internal.ItemModelType;
        static readonly CUSTOM: Internal.ItemModelType;
        static readonly GENERATED: Internal.ItemModelType;
        static readonly BLOCK: Internal.ItemModelType;
    }
    type ItemModelType_ = "block" | ItemModelType | "handheld" | "generated" | "custom";
    class AccumulatedItemCountDisplaySource extends Internal.NumericSingleLineDisplaySource {
        constructor()
        itemReceived(be: Internal.DisplayLinkBlockEntity_, amount: number): void;
    }
    type AccumulatedItemCountDisplaySource_ = AccumulatedItemCountDisplaySource;
    interface MultiPosDestructionHandler {
        abstract getExtraPositions(arg0: Internal.ClientLevel_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: number): Internal.Set<BlockPos>;
        (arg0: Internal.ClientLevel, arg1: BlockPos, arg2: Internal.BlockState, arg3: number): Internal.Set_<BlockPos>;
    }
    type MultiPosDestructionHandler_ = MultiPosDestructionHandler;
    interface GuardianEntityLightSource {
        tick(guardian: Internal.Guardian_): void;
        abstract lambdynlights$getDynamicLightBeam(): Internal.LineLightBehavior;
        abstract lambdynlights$setDynamicLightBeam(arg0: Internal.LineLightBehavior_): void;
    }
    type GuardianEntityLightSource_ = GuardianEntityLightSource;
    abstract class StateTestingPredicate implements net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate {
        static hasSturdyFace($$0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        test($$0: Internal.WorldGenLevel_, $$1: BlockPos_): boolean;
        static solid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        abstract type(): Internal.BlockPredicateType<any>;
        static matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        test(arg0: any, arg1: any): boolean;
        static matchesBlocks(...$$0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...$$0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
    }
    type StateTestingPredicate_ = StateTestingPredicate;
    interface ChannelFuture extends io.netty.util.concurrent.Future<void> {
        abstract isSuccess(): boolean;
        abstract await(): this;
        abstract addListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>): this;
        abstract awaitUninterruptibly(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract getNow(): void;
        abstract cause(): Internal.Throwable;
        abstract isVoid(): boolean;
        abstract await(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract await(arg0: number): boolean;
        abstract syncUninterruptibly(): this;
        abstract addListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>[]): this;
        exceptionNow(): Internal.Throwable;
        abstract awaitUninterruptibly(arg0: number): boolean;
        abstract get(arg0: number, arg1: Internal.TimeUnit_): void;
        abstract isCancelled(): boolean;
        abstract removeListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>[]): this;
        state(): Internal.Future$State;
        resultNow(): void;
        abstract isDone(): boolean;
        abstract cancel(arg0: boolean): boolean;
        abstract removeListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>): this;
        abstract channel(): io.netty.channel.Channel;
        abstract isCancellable(): boolean;
        abstract sync(): this;
        abstract awaitUninterruptibly(): this;
        abstract get(): void;
        get success(): boolean
        get now(): void
        get "void"(): boolean
        get cancelled(): boolean
        get done(): boolean
        get cancellable(): boolean
    }
    type ChannelFuture_ = ChannelFuture;
    class DateFormatSymbols implements Internal.Cloneable, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Locale_)
        clone(): any;
        getShortWeekdays(): string[];
        getLocalPatternChars(): string;
        getShortMonths(): string[];
        static getInstance(arg0: Internal.Locale_): Internal.DateFormatSymbols;
        setEras(arg0: string[]): void;
        setMonths(arg0: string[]): void;
        setShortMonths(arg0: string[]): void;
        getWeekdays(): string[];
        getAmPmStrings(): string[];
        setLocalPatternChars(arg0: string): void;
        static getAvailableLocales(): Internal.Locale[];
        setAmPmStrings(arg0: string[]): void;
        setWeekdays(arg0: string[]): void;
        setZoneStrings(arg0: string[][]): void;
        getEras(): string[];
        setShortWeekdays(arg0: string[]): void;
        static getInstance(): Internal.DateFormatSymbols;
        getZoneStrings(): string[][];
        getMonths(): string[];
        get shortWeekdays(): string[]
        get localPatternChars(): string
        get shortMonths(): string[]
        set eras(arg0: string[])
        set months(arg0: string[])
        set shortMonths(arg0: string[])
        get weekdays(): string[]
        get amPmStrings(): string[]
        set localPatternChars(arg0: string)
        get availableLocales(): Internal.Locale[]
        set amPmStrings(arg0: string[])
        set weekdays(arg0: string[])
        set zoneStrings(arg0: string[][])
        get eras(): string[]
        set shortWeekdays(arg0: string[])
        get instance(): Internal.DateFormatSymbols
        get zoneStrings(): string[][]
        get months(): string[]
    }
    type DateFormatSymbols_ = DateFormatSymbols;
    class YellowMapleLeavesBlock extends Internal.LeavesBlock {
        constructor(p_273704_: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type YellowMapleLeavesBlock_ = YellowMapleLeavesBlock;
    class StonecutterBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type StonecutterBlock_ = StonecutterBlock;
    abstract class AbstractWorktableRecipe implements Internal.IModifierWorktableRecipe {
        constructor(id: ResourceLocation_, toolRequirement: Internal.Ingredient_, inputs: Internal.List_<Internal.SizedIngredient>)
        constructor(id: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>)
        getGroup(): string;
        updateInputs(result: Internal.IToolStackView_, inv: Internal.ITinkerableContainer$Mutable_, selected: Internal.ModifierEntry_, isServer: boolean): void;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        abstract getDescription(arg0: Internal.ITinkerableContainer_): net.minecraft.network.chat.Component;
        getDisplayItems(slot: number): Internal.List<Internal.ItemStack>;
        toolResultSize(): number;
        /**
         * @deprecated
        */
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        updateInputs(result: Internal.IToolStackView_, inv: Internal.ITinkerableContainer$Mutable_, isServer: boolean): void;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        /**
         * @deprecated
        */
        assemble(inv: Internal.ITinkerableContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMod(): string;
        matches(inv: Internal.ITinkerableContainer_, world: Internal.Level_): boolean;
        abstract getResult(arg0: Internal.ITinkerableContainer_, arg1: Internal.ModifierEntry_): Internal.RecipeResult<Internal.ToolStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        toolResultSize(inv: Internal.ITinkerableContainer_, selected: Internal.ModifierEntry_): number;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        getModifierOptions(inv: Internal.ITinkerableContainer_): Internal.List<Internal.ModifierEntry>;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        getInputCount(): number;
        setGroup(group: string): void;
        isModifierOutput(): boolean;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        abstract getTitle(): net.minecraft.network.chat.Component;
        getRemainingItems($$0: Internal.ITinkerableContainer_): Internal.NonNullList<Internal.ItemStack>;
        getInputTools(): Internal.List<Internal.ItemStack>;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        get inputCount(): number
        set group(group: string)
        get modifierOutput(): boolean
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get title(): net.minecraft.network.chat.Component
        get inputTools(): Internal.List<Internal.ItemStack>
    }
    type AbstractWorktableRecipe_ = AbstractWorktableRecipe;
    class Component$FocusSource extends Internal.Enum<Internal.Component$FocusSource> {
        static valueOf(name: string): Internal.Component$FocusSource;
        static values(): Internal.Component$FocusSource[];
        static readonly KEYBOARD_CYCLE: Internal.Component$FocusSource;
        static readonly MOUSE_CLICK: Internal.Component$FocusSource;
    }
    type Component$FocusSource_ = "keyboard_cycle" | "mouse_click" | Component$FocusSource;
    abstract class DirectionalBlock extends Internal.Block {
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type DirectionalBlock_ = DirectionalBlock;
    class EntryGroup$Builder extends Internal.LootPoolEntryContainer$Builder<Internal.EntryGroup$Builder> {
        constructor(...$$0: Internal.LootPoolEntryContainer$Builder_<any>[])
        when<E>($$0: Internal.Iterable_<E>, $$1: Internal.Function_<E, Internal.LootItemCondition$Builder>): this;
    }
    type EntryGroup$Builder_ = EntryGroup$Builder;
    interface VillagerDataHolder extends Internal.VariantHolder<Internal.VillagerType> {
        abstract setVillagerData(arg0: Internal.VillagerData_): void;
        abstract getVillagerData(): Internal.VillagerData;
        getVariant(): Internal.VillagerType;
        setVariant(arg0: any): void;
        getVariant(): any;
        setVariant($$0: Internal.VillagerType_): void;
        set villagerData(arg0: Internal.VillagerData_)
        get villagerData(): Internal.VillagerData
        get variant(): Internal.VillagerType
        set variant(arg0: any)
        get variant(): any
        set variant($$0: Internal.VillagerType_)
    }
    type VillagerDataHolder_ = VillagerDataHolder;
    class LastSeenMessages$Update extends Internal.Record {
        constructor($$0: number, $$1: Internal.BitSet_)
        constructor($$0: Internal.FriendlyByteBuf_)
        write($$0: Internal.FriendlyByteBuf_): void;
        offset(): number;
        acknowledged(): Internal.BitSet;
    }
    type LastSeenMessages$Update_ = LastSeenMessages$Update;
    class MultiShotEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
        method_8180($$0: Internal.Enchantment_): boolean;
    }
    type MultiShotEnchantment_ = MultiShotEnchantment;
    interface IHaveGoggleInformation extends Internal.IHaveCustomOverlayIcon {
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
    }
    type IHaveGoggleInformation_ = IHaveGoggleInformation;
    class TurtleUpgradeSerialiser$2Impl extends Internal.SerialiserWithCraftingItem<T> implements Internal.TurtleUpgradeSerialiser<T> {
        static simpleWithCustomItem<T extends Internal.ITurtleUpgrade>(factory: Internal.BiFunction_<ResourceLocation, Internal.ItemStack, T>): Internal.TurtleUpgradeSerialiser<T>;
        static simple<T extends Internal.ITurtleUpgrade>(factory: Internal.Function_<ResourceLocation, T>): Internal.TurtleUpgradeSerialiser<T>;
        static registryId(): Internal.ResourceKey<Internal.Registry<Internal.TurtleUpgradeSerialiser<any>>>;
    }
    type TurtleUpgradeSerialiser$2Impl_ = TurtleUpgradeSerialiser$2Impl;
    interface Byte2BooleanFunction extends it.unimi.dsi.fastutil.Function<number, boolean>, Internal.IntPredicate {
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, boolean>;
        andThenShort(arg0: Internal.Boolean2ShortFunction_): Internal.Byte2ShortFunction;
        andThenReference<T>(arg0: Internal.Boolean2ReferenceFunction_<T>): Internal.Byte2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        or(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        negate(): Internal.IntPredicate;
        composeByte(arg0: Internal.Byte2ByteFunction_): this;
        remove(arg0: number): boolean;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2BooleanFunction;
        andThenByte(arg0: Internal.Boolean2ByteFunction_): Internal.Byte2ByteFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        get(arg0: any): boolean;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2BooleanFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: boolean): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<boolean, T>): Internal.Function<number, T>;
        containsKey(arg0: number): boolean;
        put(arg0: number, arg1: boolean): boolean;
        andThenInt(arg0: Internal.Boolean2IntFunction_): Internal.Byte2IntFunction;
        defaultReturnValue(): boolean;
        and(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        andThenDouble(arg0: Internal.Boolean2DoubleFunction_): Internal.Byte2DoubleFunction;
        abstract get(arg0: number): boolean;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: boolean): boolean;
        andThenChar(arg0: Internal.Boolean2CharFunction_): Internal.Byte2CharFunction;
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        getOrDefault(arg0: number, arg1: boolean): boolean;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2BooleanFunction;
        andThenFloat(arg0: Internal.Boolean2FloatFunction_): Internal.Byte2FloatFunction;
        size(): number;
        andThenObject<T>(arg0: Internal.Boolean2ObjectFunction_<T>): Internal.Byte2ObjectFunction<T>;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2BooleanFunction;
        andThenLong(arg0: Internal.Boolean2LongFunction_): Internal.Byte2LongFunction;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2BooleanFunction<T>;
        clear(): void;
        apply(arg0: number): boolean;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2BooleanFunction<T>;
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2BooleanFunction;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: boolean): void;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2BooleanFunction;
        (arg0: number): boolean;
    }
    type Byte2BooleanFunction_ = Byte2BooleanFunction;
    class FilteringBehaviour extends Internal.BlockEntityBehaviour implements Internal.ValueSettingsBehaviour {
        constructor(be: Internal.SmartBlockEntity_, slot: Internal.ValueBoxTransform_)
        getFilter(): Internal.ItemStack;
        showCountWhen(condition: Internal.Supplier_<boolean>): this;
        getClipboardKey(): string;
        getAmountTip(): Internal.MutableComponent;
        anyAmount(): boolean;
        withPredicate(filterPredicate: Internal.Predicate_<Internal.ItemStack>): this;
        isRecipeFilter(): boolean;
        isActive(): boolean;
        isCountVisible(): boolean;
        formatValue(value: Internal.ValueSettingsBehaviour$ValueSettings_): Internal.MutableComponent;
        canShortInteract(toApply: Internal.ItemStack_): boolean;
        getFilter(side: Internal.Direction_): Internal.ItemStack;
        bypassesInput(mainhandItem: Internal.ItemStack_): boolean;
        getTip(): Internal.MutableComponent;
        mayInteract(player: Internal.Player_): boolean;
        getLabel(): Internal.MutableComponent;
        onShortInteract(player: Internal.Player_, hand: Internal.InteractionHand_, side: Internal.Direction_, hitResult: Internal.BlockHitResult_): void;
        testHit(hit: Vec3d_): boolean;
        acceptsValueSettings(): boolean;
        getAmount(): number;
        writeToClipboard(tag: Internal.CompoundTag_, side: Internal.Direction_): boolean;
        withCallback(filterCallback: Internal.Consumer_<Internal.ItemStack>): this;
        getCountLabelForValueBox(): Internal.MutableComponent;
        getValueSettings(): Internal.ValueSettingsBehaviour$ValueSettings;
        test(stack: Internal.FluidStack_): boolean;
        onlyVisibleWithWrench(): boolean;
        netId(): number;
        setFilter(face: Internal.Direction_, stack: Internal.ItemStack_): boolean;
        setValueSettings(player: Internal.Player_, settings: Internal.ValueSettingsBehaviour$ValueSettings_, ctrlDown: boolean): void;
        playFeedbackSound(origin: Internal.BlockEntityBehaviour_): void;
        test(variant: Internal.ItemVariant_): boolean;
        getSlotPositioning(): Internal.ValueBoxTransform;
        onlyActiveWhen(condition: Internal.Supplier_<boolean>): this;
        showCount(): this;
        readFromClipboard(tag: Internal.CompoundTag_, player: Internal.Player_, side: Internal.Direction_, simulate: boolean): boolean;
        test(stack: Internal.ItemStack_): boolean;
        createBoard(player: Internal.Player_, hitResult: Internal.BlockHitResult_): Internal.ValueSettingsBoard;
        setFilter(stack: Internal.ItemStack_): boolean;
        forRecipes(): this;
        newSettingHovered(valueSetting: Internal.ValueSettingsBehaviour$ValueSettings_): void;
        getRenderDistance(): number;
        forFluids(): this;
        setLabel(label: Internal.MutableComponent_): void;
        get filter(): Internal.ItemStack
        get clipboardKey(): string
        get amountTip(): Internal.MutableComponent
        get recipeFilter(): boolean
        get active(): boolean
        get countVisible(): boolean
        get tip(): Internal.MutableComponent
        get label(): Internal.MutableComponent
        get amount(): number
        get countLabelForValueBox(): Internal.MutableComponent
        get valueSettings(): Internal.ValueSettingsBehaviour$ValueSettings
        get slotPositioning(): Internal.ValueBoxTransform
        set filter(stack: Internal.ItemStack_)
        get renderDistance(): number
        set label(label: Internal.MutableComponent_)
        upTo: boolean;
        count: number;
        static readonly TYPE: Internal.BehaviourType<Internal.FilteringBehaviour>;
        customLabel: Internal.MutableComponent;
    }
    type FilteringBehaviour_ = FilteringBehaviour;
    interface LootTableProviderAccessor {
        abstract setSubProviders(arg0: Internal.List_<Internal.LootTableProvider$SubProviderEntry>): void;
        set subProviders(arg0: Internal.List_<Internal.LootTableProvider$SubProviderEntry>)
        (arg0: Internal.List<Internal.LootTableProvider$SubProviderEntry>): void;
    }
    type LootTableProviderAccessor_ = LootTableProviderAccessor;
    class AEBaseBlockEntity extends Internal.BlockEntity implements Internal.Nameable, Internal.ISegmentedInventory, Internal.RenderAttachmentBlockEntity, Internal.Clearable {
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, blockState: Internal.BlockState_)
        saveChanges(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        markForUpdate(): void;
        method_11007(data: Internal.CompoundTag_): void;
        getTop(): Internal.Direction;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        loadTag(data: Internal.CompoundTag_): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        disassembleWithWrench(player: Internal.Player_, level: Internal.Level_, hitResult: Internal.BlockHitResult_, wrench: Internal.ItemStack_): Internal.InteractionResult;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        exportSettings(mode: Internal.SettingsFrom_, output: Internal.CompoundTag_, player: Internal.Player_): void;
        getGlobalPos(): Internal.GlobalPos;
        importSettings(mode: Internal.SettingsFrom_, input: Internal.CompoundTag_, player: Internal.Player_): void;
        setName(name: string): void;
        getOrientation(): Internal.BlockOrientation;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getReadyInvoked(): number;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        notLoaded(): boolean;
        getName(): net.minecraft.network.chat.Component;
        isClientSide(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getQueuedForReady(): number;
        hasCustomName(): boolean;
        getSubInventory(id: ResourceLocation_): Internal.InternalInventory;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getBlockEntity(): Internal.BlockEntity;
        getFront(): Internal.Direction;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        onReady(): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addAdditionalDrops(level: Internal.Level_, pos: BlockPos_, drops: Internal.List_<Internal.ItemStack>): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        static registerBlockEntityItem(type: Internal.BlockEntityType_<any>, wat: Internal.Item_): void;
        clearContent(): void;
        getCustomName(): net.minecraft.network.chat.Component;
        get displayName(): net.minecraft.network.chat.Component
        get top(): Internal.Direction
        get globalPos(): Internal.GlobalPos
        set name(name: string)
        get orientation(): Internal.BlockOrientation
        get readyInvoked(): number
        get name(): net.minecraft.network.chat.Component
        get clientSide(): boolean
        get queuedForReady(): number
        get blockEntity(): Internal.BlockEntity
        get front(): Internal.Direction
        get customName(): net.minecraft.network.chat.Component
    }
    type AEBaseBlockEntity_ = AEBaseBlockEntity;
    class BeehiveBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static dropHoneycomb($$0: Internal.Level_, $$1: BlockPos_): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        resetHoneyLevel($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: BlockPos_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        angerNearbyBees($$0: Internal.Level_, $$1: BlockPos_): void;
        emi(): Internal.EmiStack;
        releaseBeesAndResetHoneyLevel($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: Internal.Player_, $$4: Internal.BeehiveBlockEntity$BeeReleaseStatus_): void;
        hiveContainsBees($$0: Internal.Level_, $$1: BlockPos_): boolean;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly MAX_HONEY_LEVELS: 5;
        static readonly HONEY_LEVEL: Internal.IntegerProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type BeehiveBlock_ = BeehiveBlock;
    class DoubleHighBlockItem extends Internal.BlockItem {
        constructor($$0: Internal.Block_, $$1: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DoubleHighBlockItem_ = DoubleHighBlockItem;
    class ScaleType {
        getAffectsDimensions(): boolean;
        getDefaultEasing(): Internal.Float2FloatFunction;
        getDefaultTickDelay(): number;
        getDefaultBaseScale(): number;
        getDefaultBaseValueModifiers(): Internal.Set<Internal.ScaleModifier>;
        getPostTickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScaleEventCallback>;
        clampBaseScale(data: Internal.ScaleData_, newScale: number): number;
        setDefaultEasing(defaultEasing: Internal.Float2FloatFunction_): void;
        getScaleData(entity: Internal.Entity_): Internal.ScaleData;
        clampTargetScale(data: Internal.ScaleData_, newScale: number): number;
        getPreTickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScaleEventCallback>;
        getScaleChangedEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScaleEventCallback>;
        getDefaultPersistence(): boolean;
        setDefaultPersistence(persistent: boolean): void;
        get affectsDimensions(): boolean
        get defaultEasing(): Internal.Float2FloatFunction
        get defaultTickDelay(): number
        get defaultBaseScale(): number
        get defaultBaseValueModifiers(): Internal.Set<Internal.ScaleModifier>
        get postTickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScaleEventCallback>
        set defaultEasing(defaultEasing: Internal.Float2FloatFunction_)
        get preTickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScaleEventCallback>
        get scaleChangedEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScaleEventCallback>
        get defaultPersistence(): boolean
        set defaultPersistence(persistent: boolean)
    }
    type ScaleType_ = ScaleType;
    class PackOutput {
        constructor($$0: Internal.Path_)
        getOutputFolder(): Internal.Path;
        getOutputFolder($$0: Internal.PackOutput$Target_): Internal.Path;
        createPathProvider($$0: Internal.PackOutput$Target_, $$1: string): Internal.PackOutput$PathProvider;
        get outputFolder(): Internal.Path
    }
    type PackOutput_ = PackOutput;
    abstract class SpreadingSnowyDirtBlock extends Internal.SnowyDirtBlock {
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SpreadingSnowyDirtBlock_ = SpreadingSnowyDirtBlock;
    class AgriSoilCondition$Acidity extends Internal.Enum<Internal.AgriSoilCondition$Acidity> implements Internal.AgriSoilValue {
        isValid(): boolean;
        synonyms(): Internal.List<string>;
        static fromString(string: string): Internal.Optional<Internal.AgriSoilCondition$Acidity>;
        static values(): Internal.AgriSoilCondition$Acidity[];
        static valueOf(name: string): Internal.AgriSoilCondition$Acidity;
        isSynonym(string: string): boolean;
        get valid(): boolean
        static readonly INVALID: Internal.AgriSoilCondition$Acidity;
        static readonly SLIGHTLY_ALKALINE: Internal.AgriSoilCondition$Acidity;
        static readonly CODEC: Internal.Codec<Internal.AgriSoilCondition$Acidity>;
        static readonly NEUTRAL: Internal.AgriSoilCondition$Acidity;
        static readonly HIGHLY_ALKALINE: Internal.AgriSoilCondition$Acidity;
        static readonly HIGHLY_ACIDIC: Internal.AgriSoilCondition$Acidity;
        static readonly ACIDIC: Internal.AgriSoilCondition$Acidity;
        static readonly ALKALINE: Internal.AgriSoilCondition$Acidity;
        static readonly SLIGHTLY_ACIDIC: Internal.AgriSoilCondition$Acidity;
    }
    type AgriSoilCondition$Acidity_ = "neutral" | "acidic" | "slightly_alkaline" | "slightly_acidic" | "invalid" | "alkaline" | "highly_acidic" | "highly_alkaline" | AgriSoilCondition$Acidity;
    interface SuspiciousEffectHolder {
        abstract getEffectDuration(): number;
        abstract getSuspiciousEffect(): Internal.MobEffect;
        getAllEffectHolders(): Internal.List<Internal.SuspiciousEffectHolder>;
        tryGet($$0: Internal.ItemLike_): this;
        get effectDuration(): number
        get suspiciousEffect(): Internal.MobEffect
        get allEffectHolders(): Internal.List<Internal.SuspiciousEffectHolder>
    }
    type SuspiciousEffectHolder_ = SuspiciousEffectHolder;
    class WandPocketUpgrade$UpgradeSerialiser implements Internal.PocketUpgradeSerialiser<Internal.WandPocketUpgrade> {
        constructor()
        fromJson(p0: ResourceLocation_, p1: Internal.JsonObject_): Internal.UpgradeBase;
        fromNetwork(p0: ResourceLocation_, p1: Internal.FriendlyByteBuf_): Internal.UpgradeBase;
        static registryId(): Internal.ResourceKey<Internal.Registry<Internal.PocketUpgradeSerialiser<any>>>;
        static simpleWithCustomItem<T extends Internal.IPocketUpgrade>(factory: Internal.BiFunction_<ResourceLocation, Internal.ItemStack, T>): Internal.PocketUpgradeSerialiser<T>;
        toNetwork(p0: Internal.FriendlyByteBuf_, p1: Internal.UpgradeBase_): void;
        toNetwork(buffer: Internal.FriendlyByteBuf_, upgrade: Internal.WandPocketUpgrade_): void;
        static simple<T extends Internal.IPocketUpgrade>(factory: Internal.Function_<ResourceLocation, T>): Internal.PocketUpgradeSerialiser<T>;
    }
    type WandPocketUpgrade$UpgradeSerialiser_ = WandPocketUpgrade$UpgradeSerialiser;
    abstract class CableBlockItem extends Internal.BlockItem {
        constructor(block: dan200.computercraft.shared.peripheral.modem.wired.CableBlock_, settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CableBlockItem_ = CableBlockItem;
    class RegistryEventJS <T> extends Internal.StartupEventJS {
        constructor(r: Internal.RegistryInfo_<T>)
        create(id: string, type: string): Internal.BuilderBase<T>;
        createCustom(id: string, object: Internal.Supplier_<any>): Internal.CustomBuilderObject;
        /**
         * @deprecated
        */
        custom(id: string, object: any): Internal.CustomBuilderObject;
        create(id: string): Internal.BuilderBase<T>;
        readonly created: Internal.List<Internal.BuilderBase<T>>;
    }
    type RegistryEventJS_<T> = RegistryEventJS<T>;
    interface Boolean2ShortFunction extends it.unimi.dsi.fastutil.Function<boolean, number> {
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Boolean2ByteFunction;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2ShortFunction;
        put(arg0: boolean, arg1: number): number;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Boolean2DoubleFunction;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2ShortFunction<T>;
        apply(arg0: boolean): number;
        defaultReturnValue(): number;
        abstract get(arg0: boolean): number;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Boolean2IntFunction;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Boolean2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        remove(arg0: boolean): number;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2ShortFunction;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Boolean2LongFunction;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2ShortFunction;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Boolean2FloatFunction;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2ShortFunction;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2ShortFunction;
        /**
         * @deprecated
        */
        put(arg0: boolean, arg1: number): number;
        getOrDefault(arg0: boolean, arg1: number): number;
        containsKey(arg0: boolean): boolean;
        size(): number;
        defaultReturnValue(arg0: number): void;
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2ShortFunction;
        clear(): void;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<boolean, T>;
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Boolean2ObjectFunction<T>;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2ShortFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, number>;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2ShortFunction<T>;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Boolean2CharFunction;
        (arg0: boolean): number;
    }
    type Boolean2ShortFunction_ = Boolean2ShortFunction;
    class RegionType extends Internal.Enum<Internal.RegionType> {
        static valueOf(name: string): Internal.RegionType;
        static values(): Internal.RegionType[];
        static readonly NETHER: Internal.RegionType;
        static readonly OVERWORLD: Internal.RegionType;
    }
    type RegionType_ = RegionType | "overworld" | "nether";
    interface DensityFunction$ContextProvider {
        abstract forIndex(arg0: number): Internal.DensityFunction$FunctionContext;
        abstract fillAllDirectly(arg0: number[], arg1: Internal.DensityFunction_): void;
    }
    type DensityFunction$ContextProvider_ = DensityFunction$ContextProvider;
    class Frame extends Internal.Window implements Internal.MenuContainer {
        constructor()
        constructor(arg0: Internal.GraphicsConfiguration_)
        constructor(arg0: string, arg1: Internal.GraphicsConfiguration_)
        constructor(arg0: string)
        isUndecorated(): boolean;
        getExtendedState(): number;
        getTitle(): string;
        /**
         * @deprecated
        */
        setCursor(arg0: number): void;
        setState(arg0: number): void;
        static getFrames(): Internal.Frame[];
        getIconImage(): Internal.Image;
        /**
         * @deprecated
        */
        getCursorType(): number;
        setResizable(arg0: boolean): void;
        getMenuBar(): Internal.MenuBar;
        setExtendedState(arg0: number): void;
        setTitle(arg0: string): void;
        isResizable(): boolean;
        getMaximizedBounds(): Internal.Rectangle;
        setUndecorated(arg0: boolean): void;
        setMaximizedBounds(arg0: Internal.Rectangle_): void;
        getState(): number;
        setMenuBar(arg0: Internal.MenuBar_): void;
        get undecorated(): boolean
        get extendedState(): number
        get title(): string
        /**
         * @deprecated
        */
        set cursor(arg0: number)
        set state(arg0: number)
        get frames(): Internal.Frame[]
        get iconImage(): Internal.Image
        /**
         * @deprecated
        */
        get cursorType(): number
        set resizable(arg0: boolean)
        get menuBar(): Internal.MenuBar
        set extendedState(arg0: number)
        set title(arg0: string)
        get resizable(): boolean
        get maximizedBounds(): Internal.Rectangle
        set undecorated(arg0: boolean)
        set maximizedBounds(arg0: Internal.Rectangle_)
        get state(): number
        set menuBar(arg0: Internal.MenuBar_)
        /**
         * @deprecated
        */
        static readonly SW_RESIZE_CURSOR: 4;
        /**
         * @deprecated
        */
        static readonly NE_RESIZE_CURSOR: 7;
        /**
         * @deprecated
        */
        static readonly W_RESIZE_CURSOR: 10;
        /**
         * @deprecated
        */
        static readonly DEFAULT_CURSOR: 0;
        /**
         * @deprecated
        */
        static readonly MOVE_CURSOR: 13;
        /**
         * @deprecated
        */
        static readonly CROSSHAIR_CURSOR: 1;
        static readonly MAXIMIZED_VERT: 4;
        /**
         * @deprecated
        */
        static readonly N_RESIZE_CURSOR: 8;
        /**
         * @deprecated
        */
        static readonly TEXT_CURSOR: 2;
        static readonly MAXIMIZED_HORIZ: 2;
        static readonly MAXIMIZED_BOTH: 6;
        /**
         * @deprecated
        */
        static readonly WAIT_CURSOR: 3;
        static readonly ICONIFIED: 1;
        /**
         * @deprecated
        */
        static readonly S_RESIZE_CURSOR: 9;
        static readonly NORMAL: 0;
        /**
         * @deprecated
        */
        static readonly HAND_CURSOR: 12;
        /**
         * @deprecated
        */
        static readonly SE_RESIZE_CURSOR: 5;
        /**
         * @deprecated
        */
        static readonly NW_RESIZE_CURSOR: 6;
        /**
         * @deprecated
        */
        static readonly E_RESIZE_CURSOR: 11;
    }
    type Frame_ = Frame;
    class DyeableHorseArmorItem extends Internal.HorseArmorItem implements Internal.DyeableLeatherItem {
        constructor($$0: number, $$1: string, $$2: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getColor($$0: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        hasCustomColor($$0: Internal.ItemStack_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static dyeArmor($$0: Internal.ItemStack_, $$1: Internal.List_<Internal.DyeItem>): Internal.ItemStack;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setColor($$0: Internal.ItemStack_, $$1: number): void;
        emi(amount: number): Internal.EmiStack;
        clearColor($$0: Internal.ItemStack_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DyeableHorseArmorItem_ = DyeableHorseArmorItem;
    class MathContext implements Internal.Serializable {
        constructor(arg0: number)
        constructor(arg0: number, arg1: Internal.RoundingMode_)
        constructor(arg0: string)
        getPrecision(): number;
        getRoundingMode(): Internal.RoundingMode;
        get precision(): number
        get roundingMode(): Internal.RoundingMode
        static readonly DECIMAL128: Internal.MathContext;
        static readonly UNLIMITED: Internal.MathContext;
        static readonly DECIMAL32: Internal.MathContext;
        static readonly DECIMAL64: Internal.MathContext;
    }
    type MathContext_ = MathContext;
    interface ComponentContainer extends Internal.NbtSerializable {
        abstract tickServerComponents(): void;
        abstract onServerLoad(): void;
        toDynamic<T>(dynamic: Internal.Dynamic_<T>): Internal.Dynamic<T>;
        abstract tickClientComponents(): void;
        abstract onClientUnload(): void;
        fromDynamic(dynamic: Internal.Dynamic_<any>): void;
        abstract onServerUnload(): void;
        abstract toTag(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        abstract keys(): Internal.Set<Internal.ComponentKey<any>>;
        abstract copyFrom(arg0: Internal.ComponentContainer_): void;
        abstract onClientLoad(): void;
        abstract fromTag(arg0: Internal.CompoundTag_): void;
        abstract hasComponents(): boolean;
        readonly EMPTY: Internal.ComponentContainer;
    }
    type ComponentContainer_ = ComponentContainer;
    class EntityDataAccessor <T> {
        constructor($$0: number, $$1: Internal.EntityDataSerializer_<T>)
        getSerializer(): Internal.EntityDataSerializer<T>;
        getId(): number;
        get serializer(): Internal.EntityDataSerializer<T>
        get id(): number
        id: number;
    }
    type EntityDataAccessor_<T> = EntityDataAccessor<T>;
    class Potion {
        constructor($$0: string, ...$$1: Internal.MobEffectInstance_[])
        constructor(...$$0: Internal.MobEffectInstance_[])
        getEffects(): Internal.List<Internal.MobEffectInstance>;
        hasInstantEffects(): boolean;
        static byName($$0: string): Internal.Potion;
        getName($$0: string): string;
        get effects(): Internal.List<Internal.MobEffectInstance>
    }
    type Potion_ = Potion | Special.Potion;
    abstract class ZoneId implements Internal.Serializable {
        static of(arg0: string): Internal.ZoneId;
        static systemDefault(): Internal.ZoneId;
        abstract getRules(): Internal.ZoneRules;
        static ofOffset(arg0: string, arg1: Internal.ZoneOffset_): Internal.ZoneId;
        static getAvailableZoneIds(): Internal.Set<string>;
        static of(arg0: string, arg1: Internal.Map_<string, string>): Internal.ZoneId;
        abstract getId(): string;
        getDisplayName(arg0: Internal.TextStyle_, arg1: Internal.Locale_): string;
        static from(arg0: Internal.TemporalAccessor_): Internal.ZoneId;
        normalized(): this;
        get rules(): Internal.ZoneRules
        get availableZoneIds(): Internal.Set<string>
        get id(): string
        static readonly SHORT_IDS: {"PST": "America/Los_Angeles", "ART": "Africa/Cairo", "JST": "Asia/Tokyo", "VST": "Asia/Ho_Chi_Minh", "IET": "America/Indiana/Indianapolis", "CNT": "America/St_Johns", "PLT": "Asia/Karachi", "PNT": "America/Phoenix", "EST": "-05:00", "EAT": "Africa/Addis_Ababa", "ECT": "Europe/Paris", "PRT": "America/Puerto_Rico", "CTT": "Asia/Shanghai", "SST": "Pacific/Guadalcanal", "MST": "-07:00", "AST": "America/Anchorage", "NST": "Pacific/Auckland", "HST": "-10:00", "ACT": "Australia/Darwin", "BST": "Asia/Dhaka", "AET": "Australia/Sydney", "IST": "Asia/Kolkata", "CST": "America/Chicago", "NET": "Asia/Yerevan", "AGT": "America/Argentina/Buenos_Aires", "CAT": "Africa/Harare", "MIT": "Pacific/Apia", "BET": "America/Sao_Paulo"};
    }
    type ZoneId_ = ZoneId;
    interface RemappableRegistry {
        abstract remap(arg0: string, arg1: Internal.Object2IntMap_<ResourceLocation>, arg2: Internal.RemappableRegistry$RemapMode_): void;
        abstract unmap(arg0: string): void;
    }
    type RemappableRegistry_ = RemappableRegistry;
    class BambooStalkBlock extends Internal.Block implements Internal.IPlantable, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        getPlant(world: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STAGE: Internal.IntegerProperty;
        static readonly AGE_THIN_BAMBOO: 0;
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_HEIGHT: 16;
        static readonly AGE_THICK_BAMBOO: 1;
        static readonly LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
        static readonly STAGE_DONE_GROWING: 1;
        static readonly STAGE_GROWING: 0;
    }
    type BambooStalkBlock_ = BambooStalkBlock;
    class ValueLayouts$OfShortImpl extends Internal.ValueLayouts$AbstractValueLayout<Internal.ValueLayouts$OfShortImpl> implements Internal.ValueLayout$OfShort {
        static sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        static sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        byteOffset(...arg0: any_[]): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        static structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withName(arg0: string): Internal.ValueLayout$OfShort;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        static paddingLayout(arg0: number): Internal.PaddingLayout;
        static of(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfShort;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfShort;
        static unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        withoutName(): Internal.ValueLayout$OfShort;
    }
    type ValueLayouts$OfShortImpl_ = ValueLayouts$OfShortImpl;
    class FabricDataOutput extends Internal.PackOutput {
        constructor(modContainer: Internal.ModContainer_, path: Internal.Path_, strictValidation: boolean)
        getModContainer(): Internal.ModContainer;
        getModId(): string;
        isStrictValidationEnabled(): boolean;
        get modContainer(): Internal.ModContainer
        get modId(): string
        get strictValidationEnabled(): boolean
    }
    type FabricDataOutput_ = FabricDataOutput;
    class StringBuilder extends Internal.AbstractStringBuilder implements Internal.CharSequence, Internal.Appendable, Internal.Comparable<Internal.StringBuilder>, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.CharSequence_)
        constructor(arg0: number)
        constructor(arg0: string)
        replace(arg0: number, arg1: number, arg2: string): this;
        repeat(arg0: Internal.CharSequence_, arg1: number): this;
        reverse(): this;
        insert(arg0: number, arg1: Internal.CharSequence_): this;
        insert(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: number): this;
        "delete"(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: string): this;
        isEmpty(): boolean;
        append(arg0: string): Internal.Appendable;
        compareTo(arg0: any): number;
        compareTo(arg0: Internal.StringBuilder_): number;
        static compare(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_): number;
        deleteCharAt(arg0: number): this;
        insert(arg0: number, arg1: boolean): this;
        insert(arg0: number, arg1: Internal.CharSequence_, arg2: number, arg3: number): this;
        insert(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: string): this;
        insert(arg0: number, arg1: string[]): this;
        get empty(): boolean
    }
    type StringBuilder_ = StringBuilder;
    class ClientboundForgetLevelChunkPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getX(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getZ(): number;
        isSkippable(): boolean;
        get x(): number
        get z(): number
        get skippable(): boolean
    }
    type ClientboundForgetLevelChunkPacket_ = ClientboundForgetLevelChunkPacket;
    class ItemBatteryStaff extends Internal.ItemStaff implements Internal.MediaHolderItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRecharge(stack: Internal.ItemStack_): boolean;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static withMedia(stack: Internal.ItemStack_, media: number, maxMedia: number): Internal.ItemStack;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        getMedia(stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getMediaFullness(stack: Internal.ItemStack_): number;
        canProvideMedia(stack: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        setMedia(stack: Internal.ItemStack_, media: number): void;
        withdrawMedia(stack: Internal.ItemStack_, cost: number, simulate: boolean): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getMaxMedia(stack: Internal.ItemStack_): number;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly CAPACITY_IN_DUST: 30;
    }
    type ItemBatteryStaff_ = ItemBatteryStaff;
    class Botarium$1 extends Internal.ParticleType<Internal.FluidParticleOptions> {
        codec(): Internal.Codec<Internal.FluidParticleOptions>;
    }
    type Botarium$1_ = Botarium$1;
    class RiceRollMedleyBlock extends Internal.FeastBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly ROLL_SERVINGS: Internal.IntegerProperty;
        readonly riceRollServings: Internal.List<Internal.Supplier<Internal.Item>>;
    }
    type RiceRollMedleyBlock_ = RiceRollMedleyBlock;
    class Structure$GenerationStub extends Internal.Record {
        constructor($$0: BlockPos_, $$1: Internal.Either_<Internal.Consumer<Internal.StructurePiecesBuilder>, Internal.StructurePiecesBuilder>)
        constructor($$0: BlockPos_, $$1: Internal.Consumer_<Internal.StructurePiecesBuilder>)
        generator(): Internal.Either<Internal.Consumer<Internal.StructurePiecesBuilder>, Internal.StructurePiecesBuilder>;
        getPiecesBuilder(): Internal.StructurePiecesBuilder;
        position(): BlockPos;
        get piecesBuilder(): Internal.StructurePiecesBuilder
    }
    type Structure$GenerationStub_ = Structure$GenerationStub;
    interface AbstractFadeModifier$EasingFunction {
        abstract ease(arg0: string, arg1: Internal.TransformType_, arg2: number): number;
        (arg0: string, arg1: Internal.TransformType, arg2: number): number;
    }
    type AbstractFadeModifier$EasingFunction_ = AbstractFadeModifier$EasingFunction;
}
declare namespace appeng.block.networking {
    class EnergyCellBlock extends Internal.AEBaseEntityBlock<any> {
        constructor(maxPower: number, chargeRate: number, priority: number)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getChargeRate(): number;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMaxPower(): number;
        emi(amount: number): Internal.EmiStack;
        getPriority(): number;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get chargeRate(): number
        set destroySpeed(v: number)
        get maxPower(): number
        get priority(): number
        static readonly MAX_FULLNESS: 4;
        static readonly ENERGY_STORAGE: Internal.IntegerProperty;
    }
    type EnergyCellBlock_ = EnergyCellBlock;
}
declare namespace net.fabricmc.fabric.api.event {
    abstract class Event <T> {
        constructor()
        invoker(): T;
        abstract register(arg0: T): void;
        register(phase: ResourceLocation_, listener: T): void;
        addPhaseOrdering(firstPhase: ResourceLocation_, secondPhase: ResourceLocation_): void;
        static readonly DEFAULT_PHASE: ResourceLocation;
    }
    type Event_<T> = Event<T>;
}
declare namespace software.bernie.geckolib.core.animation {
    class Animation extends Internal.Record {
        constructor(name: string, length: number, loopType: Internal.Animation$LoopType_, boneAnimations: any_[], keyFrames: Internal.Animation$Keyframes_)
        name(): string;
        boneAnimations(): any[];
        length(): number;
        loopType(): Internal.Animation$LoopType;
        keyFrames(): Internal.Animation$Keyframes;
    }
    type Animation_ = Animation;
}
